/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.conveyor;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.conveyor.BlockConveyor;
import com.lothrazar.cyclic.block.conveyor.ConveyorSpeed;
import com.lothrazar.cyclic.block.conveyor.ConveyorType;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class TileConveyor
extends TileBlockEntityCyclic {
    public TileConveyor(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.CONVEYOR.get(), pos, state);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileConveyor e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileConveyor e) {
        e.tick();
    }

    public void tick() {
        if (this.f_58857_ == null || this.f_58858_ == null) {
            return;
        }
        List entities = this.f_58857_.m_45976_(Entity.class, new AABB(this.f_58858_).m_82363_(0.0, 0.5, 0.0));
        for (Entity e : entities) {
            TileConveyor.makeEntitiesTravel(e, this.m_58900_(), this.f_58858_, this.f_58857_);
        }
    }

    public static void makeEntitiesTravel(Entity entity, BlockState bs, BlockPos pos, Level world) {
        Player p;
        if (entity instanceof Player && (p = (Player)entity).m_6047_()) {
            return;
        }
        double normalizedX = entity.m_20185_() - (double)pos.m_123341_();
        double normalizedZ = entity.m_20189_() - (double)pos.m_123343_();
        double offside = 0.01;
        Direction facing = (Direction)bs.m_61143_((Property)BlockStateProperties.f_61374_);
        if (facing.m_122434_() == Direction.Axis.Z && (normalizedX > 0.99 || normalizedX < 0.01)) {
            return;
        }
        if (facing.m_122434_() == Direction.Axis.X && (normalizedZ > 0.99 || normalizedZ < 0.01)) {
            return;
        }
        ConveyorType type = (ConveyorType)((Object)bs.m_61143_(BlockConveyor.TYPE));
        double heightLimit = type.isVertical() ? (double)pos.m_123342_() + 1.3 : (double)pos.m_123342_() + 0.125;
        double speed = ((ConveyorSpeed)((Object)bs.m_61143_(BlockConveyor.SPEED))).getSpeed();
        double xSpeed = 0.0;
        double zSpeed = 0.0;
        double ySpeed = 0.0;
        if (entity.m_20186_() > heightLimit) {
            return;
        }
        xSpeed = (double)facing.m_122429_() * speed;
        ySpeed = 0.0;
        zSpeed = (double)facing.m_122431_() * speed;
        if (type.isCorner()) {
            if (facing.m_122434_() == Direction.Axis.Z && (normalizedX < 0.4 || normalizedX > 0.6)) {
                entity.m_6034_(Math.floor(entity.m_20185_()) + 0.5, entity.m_20186_(), entity.m_20189_());
            }
            if (facing.m_122434_() == Direction.Axis.X && (normalizedZ < 0.4 || normalizedZ > 0.6)) {
                entity.m_6034_(entity.m_20185_(), entity.m_20186_(), Math.floor(entity.m_20189_()) + 0.5);
            }
        }
        if (type.isVertical()) {
            double hackEdge = 0.1;
            if (normalizedX < hackEdge || normalizedZ < hackEdge || normalizedX > 1.0 - hackEdge || normalizedZ > 1.0 - hackEdge) {
                entity.m_6034_(entity.m_20185_(), entity.m_20186_() + 0.2, entity.m_20189_());
            }
            ySpeed = speed * 1.3;
            if (type == ConveyorType.DOWN) {
                ySpeed *= -1.0;
            }
        }
        if (xSpeed != 0.0 || ySpeed != 0.0 || zSpeed != 0.0) {
            entity.m_20334_(xSpeed, ySpeed, zSpeed);
        }
    }
}

